/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.PartialBeam;
import gui.MainWindow;
import gui.MessageBox;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import ui.Ui_BeamEditor;
import utils.JamMtException;
import utils.Settings;

public class BeamEditor
extends Ui_BeamEditor
implements ActionListener {
    private Settings sets = MainWindow.getInstance().getSettings();
    private JFrame owner;

    public BeamEditor(JFrame owner) {
        super((Frame)owner, true);
        this.owner = owner;
        this.w0tan.setVisible(this.sets.showTan);
        this.z0tan.setVisible(this.sets.showTan);
        this.lW0tan.setVisible(this.sets.showTan);
        this.lZ0tan.setVisible(this.sets.showTan);
        PartialBeam b = MainWindow.getInstance().getBeam().getInitialBeam();
        this.w0.setText("" + b.getWaistSize("x") * 1000000.0);
        this.z0.setText("" + b.getWaistPosition("x"));
        this.w0tan.setText("" + b.getWaistSize("y") * 1000000.0);
        this.z0tan.setText("" + b.getWaistPosition("y"));
        this.lambda.setText("" + b.getWaveLength() * 1.0E9);
        this.w0.selectAll();
        this.z0.selectAll();
        this.w0tan.selectAll();
        this.z0tan.selectAll();
        this.lambda.selectAll();
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            try {
                PartialBeam b = null;
                b = this.sets.showTan ? new PartialBeam(Double.parseDouble(this.w0.getText()) * 1.0E-6, Double.parseDouble(this.z0.getText()), Double.parseDouble(this.w0tan.getText()) * 1.0E-6, Double.parseDouble(this.z0tan.getText()), Double.parseDouble(this.lambda.getText()) * 1.0E-9) : new PartialBeam(Double.parseDouble(this.w0.getText()) * 1.0E-6, Double.parseDouble(this.z0.getText()), Double.parseDouble(this.w0.getText()) * 1.0E-6, Double.parseDouble(this.z0.getText()), Double.parseDouble(this.lambda.getText()) * 1.0E-9);
                MainWindow.getInstance().getBeam().setInitialBeam(b);
                this.setVisible(false);
                this.dispose();
            }
            catch (JamMtException ex) {
                new MessageBox(this.owner, ex.getMessage());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

