/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.BeamAnalyzer;
import components.Component;
import gui.BeamAnalyzerEditor;
import gui.MainWindow;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ui.Ui_BeamAnalyzerManager;
import utils.ABCDmatrix;
import utils.Beam;
import utils.BeamObserver;
import utils.Formatter;
import utils.JamMtException;
import utils.Observer;

public class BeamAnalyzerManager
extends Ui_BeamAnalyzerManager
implements ActionListener,
Observer,
BeamObserver,
ListSelectionListener {
    private Beam beam;
    private DefaultListModel listcontent = new DefaultListModel();

    public BeamAnalyzerManager(JFrame owner) {
        super((Frame)owner, false);
        this.edit.addActionListener(this);
        this.delete.addActionListener(this);
        this.add.addActionListener(this);
        this.beam = MainWindow.getInstance().getBeam();
        this.beam.attach(this);
        this.getBeamAnalyzer(this.listcontent);
        this.list.setModel(this.listcontent);
        this.list.addListSelectionListener(this);
        this.updateDisplay();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int idx;
        if (e.getActionCommand().equals("Delete")) {
            idx = this.list.getSelectedIndex();
            if (idx >= 0) {
                MainWindow.getInstance().getOpticalComponents().removeAnalyzer(idx);
            }
            this.getBeamAnalyzer(this.listcontent);
            this.list.setSelectedIndex(this.list.getLastVisibleIndex());
            this.beam.fireUpdate();
        }
        if (e.getActionCommand().equals("Add")) {
            new BeamAnalyzerEditor(MainWindow.getInstance().getMainWnd(), null);
            this.getBeamAnalyzer(this.listcontent);
            this.list.setSelectedIndex(this.list.getLastVisibleIndex());
        }
        if (e.getActionCommand().equals("Edit") && (idx = this.list.getSelectedIndex()) >= 0) {
            new BeamAnalyzerEditor(MainWindow.getInstance().getMainWnd(), MainWindow.getInstance().getOpticalComponents().getBeamAnalyzer().get(idx));
            this.getBeamAnalyzer(this.listcontent);
            this.list.setSelectedIndex(idx);
        }
    }

    private void getBeamAnalyzer(DefaultListModel dlm) {
        dlm.clear();
        for (BeamAnalyzer ba : MainWindow.getInstance().getOpticalComponents().getBeamAnalyzer()) {
            double pos = ba.getPosition();
            String entry = "<html>" + ba.getName() + " @ " + Formatter.defaultFormat(pos) + " m<br>";
            entry = entry + "q = " + this.beam.getQParameterAt(pos) + ", w = " + Formatter.defaultFormat(this.beam.getWaistSizeAt(pos, "x") * 1000000.0) + " \u03bcm</html>";
            dlm.addElement(entry);
            ba.attach(this);
        }
    }

    private void updateDisplay() {
        ArrayList<BeamAnalyzer> analyzer;
        int listSize;
        int idx = this.list.getSelectedIndex();
        if (idx >= (listSize = (analyzer = MainWindow.getInstance().getOpticalComponents().getBeamAnalyzer()).size())) {
            return;
        }
        this.list.removeAll();
        this.getBeamAnalyzer(this.listcontent);
        this.list.setModel(this.listcontent);
        this.list.setSelectedIndex(idx);
        double pos = idx >= 0 ? analyzer.get(idx).getPosition() : 0.0;
        this.position.setText("z = " + Formatter.defaultFormat(pos) + " m");
        this.w0sag.setText("w = " + Formatter.defaultFormat(this.beam.getWaistSizeAt(pos, "x") * 1000000.0) + " \u03bcm");
        this.Rsag.setText("R = " + Formatter.defaultFormat(this.beam.getRadiusAt(pos, "x")) + " m");
        this.phiSag.setText("phi = " + Formatter.defaultFormat(this.beam.getGouyPhaseAt(pos, "x") * 180.0 / Math.PI) + " \u00b0");
        this.w0tran.setText("w = " + Formatter.defaultFormat(this.beam.getWaistSizeAt(pos, "y") * 1000000.0) + " \u03bcm");
        this.Rtran.setText("R = " + Formatter.defaultFormat(this.beam.getRadiusAt(pos, "y")) + " m");
        this.phitran.setText("phi = " + Formatter.defaultFormat(this.beam.getGouyPhaseAt(pos, "y") * 180.0 / Math.PI) + " \u00b0");
        try {
            ABCDmatrix M = MainWindow.getInstance().getOpticalComponents().getABCDmatrixAt(pos, "x");
            this.aSag.setText("A = " + Formatter.defaultFormat(M.getElement("A")));
            this.bSag.setText("B = " + Formatter.defaultFormat(M.getElement("B")));
            this.cSag.setText("C = " + Formatter.defaultFormat(M.getElement("C")));
            this.dSag.setText("D = " + Formatter.defaultFormat(M.getElement("D")));
            M = MainWindow.getInstance().getOpticalComponents().getABCDmatrixAt(pos, "y");
            this.aTran.setText("A = " + Formatter.defaultFormat(M.getElement("A")));
            this.bTran.setText("B = " + Formatter.defaultFormat(M.getElement("B")));
            this.cTran.setText("C = " + Formatter.defaultFormat(M.getElement("C")));
            this.dTran.setText("D = " + Formatter.defaultFormat(M.getElement("D")));
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        this.notebook.repaint();
    }

    @Override
    public void beamUpdate(Beam b) {
        this.updateDisplay();
    }

    @Override
    public void update(Component comp) {
        this.updateDisplay();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.list.removeListSelectionListener(this);
        this.updateDisplay();
        this.list.addListSelectionListener(this);
    }
}

