/*
 * Decompiled with CFR 0.152.
 */
package gui;

import components.BeamAnalyzer;
import gui.MainWindow;
import gui.MessageBox;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import ui.Ui_BeamAnalyzerEditor;
import utils.JamMtException;

public class BeamAnalyzerEditor
extends Ui_BeamAnalyzerEditor
implements ActionListener {
    private BeamAnalyzer ba_old;
    private JFrame owner;

    public BeamAnalyzerEditor(JFrame owner, BeamAnalyzer ba_old) {
        super((Frame)owner, true);
        this.ba_old = ba_old;
        this.owner = owner;
        if (ba_old == null) {
            this.name.setText("Beam analyzer");
            this.label.setText("0.0");
        } else {
            this.name.setText(ba_old.getName());
            this.label.setText("" + ba_old.getPosition());
        }
        this.name.selectAll();
        this.label.selectAll();
        this.ok.addActionListener(this);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            BeamAnalyzer ba_new = new BeamAnalyzer(this.name.getText(), Double.parseDouble(this.label.getText()), 0, MainWindow.getInstance().getBeam());
            if (this.ba_old != null) {
                MainWindow.getInstance().getOpticalComponents().removeComponent(this.ba_old);
            }
            MainWindow.getInstance().getOpticalComponents().addComponent(ba_new);
            MainWindow.getInstance().getOpticalComponents().setCurrent(ba_new);
            this.dispose();
        }
        catch (JamMtException ex) {
            new MessageBox(this.owner, ex.getMessage());
        }
    }
}

