/*
 * Decompiled with CFR 0.152.
 */
package ext;

import ext.ArrayConverter;
import ext.JAMAMatrix;
import ext.LMAFunction;
import ext.LMAMatrix;
import ext.LMAMultiDimFunction;
import java.util.Arrays;

public class LMA {
    public boolean verbose = false;
    public LMAMultiDimFunction function;
    public double[] parameters;
    public double[] yDataPoints;
    public double[][] xDataPoints;
    public double[] weights;
    public LMAMatrix alpha;
    public double[] beta;
    public double[] da;
    public double lambda = 0.001;
    public double lambdaFactor = 10.0;
    public double incrementedChi2;
    public double[] incrementedParameters;
    public int iterationCount;
    public double chi2;
    public double minDeltaChi2 = 1.0E-30;
    public int maxIterations = 100;

    public LMA(LMAFunction lMAFunction, double[] dArray, double[][] dArray2) {
        this(lMAFunction, dArray, dArray2, lMAFunction.constructWeights(dArray2));
    }

    public LMA(final LMAFunction lMAFunction, double[] dArray, double[][] dArray2, double[] dArray3) {
        this(new LMAMultiDimFunction(){
            private LMAFunction f;
            {
                this.f = lMAFunction;
            }

            @Override
            public double getPartialDerivate(double[] dArray, double[] dArray2, int n) {
                return this.f.getPartialDerivate(dArray[0], dArray2, n);
            }

            @Override
            public double getY(double[] dArray, double[] dArray2) {
                return this.f.getY(dArray[0], dArray2);
            }
        }, dArray, dArray2[1], ArrayConverter.transpose(dArray2[0]), dArray3, new JAMAMatrix(dArray.length, dArray.length));
    }

    public LMA(LMAFunction lMAFunction, float[] fArray, float[][] fArray2) {
        this(lMAFunction, ArrayConverter.asDoubleArray(fArray), ArrayConverter.asDoubleArray(fArray2));
    }

    public LMA(LMAFunction lMAFunction, float[] fArray, float[][] fArray2, float[] fArray3) {
        this(lMAFunction, ArrayConverter.asDoubleArray(fArray), ArrayConverter.asDoubleArray(fArray2), ArrayConverter.asDoubleArray(fArray3));
    }

    public LMA(LMAMultiDimFunction lMAMultiDimFunction, float[] fArray, float[][] fArray2) {
        this(lMAMultiDimFunction, ArrayConverter.asDoubleArray(fArray), ArrayConverter.asDoubleArray(fArray2), lMAMultiDimFunction.constructWeights(ArrayConverter.asDoubleArray(fArray2)), (LMAMatrix)new JAMAMatrix(fArray.length, fArray.length));
    }

    public LMA(LMAMultiDimFunction lMAMultiDimFunction, double[] dArray, double[][] dArray2) {
        this(lMAMultiDimFunction, dArray, dArray2, lMAMultiDimFunction.constructWeights(dArray2), (LMAMatrix)new JAMAMatrix(dArray.length, dArray.length));
    }

    public LMA(LMAMultiDimFunction lMAMultiDimFunction, double[] dArray, float[] fArray, float[][] fArray2) {
        this(lMAMultiDimFunction, dArray, ArrayConverter.asDoubleArray(fArray), ArrayConverter.asDoubleArray(fArray2), lMAMultiDimFunction.constructWeights(ArrayConverter.combineMultiDimDataPoints(fArray, fArray2)), new JAMAMatrix(dArray.length, dArray.length));
    }

    public LMA(LMAMultiDimFunction lMAMultiDimFunction, double[] dArray, double[] dArray2, double[][] dArray3) {
        this(lMAMultiDimFunction, dArray, dArray2, dArray3, lMAMultiDimFunction.constructWeights(ArrayConverter.combineMultiDimDataPoints(dArray2, dArray3)), new JAMAMatrix(dArray.length, dArray.length));
    }

    public LMA(LMAMultiDimFunction lMAMultiDimFunction, float[] fArray, float[][] fArray2, float[] fArray3, LMAMatrix lMAMatrix) {
        this(lMAMultiDimFunction, ArrayConverter.asDoubleArray(fArray), ArrayConverter.asDoubleArray(fArray2), ArrayConverter.asDoubleArray(fArray3), lMAMatrix);
    }

    public LMA(LMAMultiDimFunction lMAMultiDimFunction, double[] dArray, double[][] dArray2, double[] dArray3, LMAMatrix lMAMatrix) {
    }

    public LMA(LMAMultiDimFunction lMAMultiDimFunction, double[] dArray, double[] dArray2, double[][] dArray3, double[] dArray4, LMAMatrix lMAMatrix) {
        this.init(lMAMultiDimFunction, dArray, dArray2, dArray3, dArray4, lMAMatrix);
    }

    protected void init(LMAMultiDimFunction lMAMultiDimFunction, double[] dArray, double[] dArray2, double[][] dArray3, double[] dArray4, LMAMatrix lMAMatrix) {
        if (dArray2.length != dArray3.length) {
            throw new IllegalArgumentException("Data must contain an x-array for each y-value. Check your xDataPoints-array.");
        }
        this.function = lMAMultiDimFunction;
        this.parameters = dArray;
        this.yDataPoints = dArray2;
        this.xDataPoints = dArray3;
        this.weights = this.checkWeights(dArray2.length, dArray4);
        this.incrementedParameters = new double[dArray.length];
        this.alpha = lMAMatrix;
        this.beta = new double[dArray.length];
        this.da = new double[dArray.length];
    }

    public void fit() throws LMAMatrix.InvertException {
        this.iterationCount = 0;
        if (Double.isNaN(this.calculateChi2())) {
            throw new RuntimeException("INITIAL PARAMETERS ARE ILLEGAL.");
        }
        do {
            this.chi2 = this.calculateChi2();
            if (this.verbose) {
                System.out.println(this.iterationCount + ": chi2 = " + this.chi2 + ", " + Arrays.toString(this.parameters));
            }
            this.updateAlpha();
            this.updateBeta();
            try {
                this.solveIncrements();
                this.incrementedChi2 = this.calculateIncrementedChi2();
                if (this.incrementedChi2 >= this.chi2 || Double.isNaN(this.incrementedChi2)) {
                    this.lambda *= this.lambdaFactor;
                } else {
                    this.lambda /= this.lambdaFactor;
                    this.updateParameters();
                }
            }
            catch (LMAMatrix.InvertException invertException) {
                if (this.iterationCount == this.maxIterations) {
                    throw invertException;
                }
                if (this.verbose) {
                    System.out.println(invertException.getMessage());
                }
                this.lambda *= this.lambdaFactor;
            }
            ++this.iterationCount;
        } while (!this.stop());
        this.printEndReport();
    }

    private void printEndReport() {
        if (this.verbose) {
            System.out.println(" ***** FIT ENDED ***** ");
            System.out.println(" Goodness: " + this.chi2Goodness());
            try {
                System.out.println(" Parameter std errors: " + Arrays.toString(this.getStandardErrorsOfParameters()));
            }
            catch (LMAMatrix.InvertException invertException) {
                System.err.println(" Fit ended OK, but cannot calculate covariance matrix.");
                System.out.println(" ********************* ");
            }
            System.out.println(" ********************* ");
        }
    }

    public void fit(double d, double d2, int n) throws LMAMatrix.InvertException {
        this.lambda = d;
        this.minDeltaChi2 = d2;
        this.maxIterations = n;
        this.fit();
    }

    public boolean stop() {
        return Math.abs(this.chi2 - this.incrementedChi2) < this.minDeltaChi2 || this.iterationCount > this.maxIterations;
    }

    protected void updateParameters() {
        System.arraycopy(this.incrementedParameters, 0, this.parameters, 0, this.parameters.length);
    }

    protected void solveIncrements() throws LMAMatrix.InvertException {
        this.alpha.invert();
        this.alpha.multiply(this.beta, this.da);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.incrementedParameters[i] = this.parameters[i] + this.da[i];
        }
    }

    protected double calculateChi2(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.yDataPoints.length; ++i) {
            double d2 = this.yDataPoints[i] - this.function.getY(this.xDataPoints[i], dArray);
            if (Double.isNaN(d2)) {
                System.err.println("Chi2 calculation produced a NaN value at point " + i + ":\n" + " x = " + Arrays.toString(this.xDataPoints[i]) + "\n" + " y = " + this.yDataPoints[i] + "\n" + " parameters: " + Arrays.toString(dArray) + "\n" + " iteration count = " + this.iterationCount);
                return Double.NaN;
            }
            d += this.weights[i] * d2 * d2;
        }
        return d;
    }

    protected double calculateChi2() {
        return this.calculateChi2(this.parameters);
    }

    protected double calculateIncrementedChi2() {
        return this.calculateChi2(this.incrementedParameters);
    }

    protected void updateAlpha() {
        for (int i = 0; i < this.parameters.length; ++i) {
            for (int j = 0; j < this.parameters.length; ++j) {
                this.alpha.setElement(i, j, this.calculateAlphaElement(i, j));
            }
        }
    }

    protected double calculateAlphaElement(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.yDataPoints.length; ++i) {
            d += this.weights[i] * this.function.getPartialDerivate(this.xDataPoints[i], this.parameters, n) * this.function.getPartialDerivate(this.xDataPoints[i], this.parameters, n2);
        }
        if (n == n2) {
            d *= 1.0 + this.lambda;
        }
        return d;
    }

    protected void updateBeta() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.beta[i] = this.calculateBetaElement(i);
        }
    }

    protected double calculateBetaElement(int n) {
        double d = 0.0;
        for (int i = 0; i < this.yDataPoints.length; ++i) {
            d += this.weights[i] * (this.yDataPoints[i] - this.function.getY(this.xDataPoints[i], this.parameters)) * this.function.getPartialDerivate(this.xDataPoints[i], this.parameters, n);
        }
        return d;
    }

    public float getRelativeChi2() {
        float f = 0.0f;
        for (int i = 0; i < this.yDataPoints.length; ++i) {
            double d = this.yDataPoints[i] - this.function.getY(this.xDataPoints[i], this.parameters);
            if (this.yDataPoints[i] == 0.0) continue;
            f = (float)((double)f + (double)((float)(d * d)) / this.yDataPoints[i]);
        }
        return f;
    }

    public float getMeanRelativeError() {
        float f = 0.0f;
        for (int i = 0; i < this.yDataPoints.length; ++i) {
            double d = this.function.getY(this.xDataPoints[i], this.parameters);
            double d2 = Math.abs(this.yDataPoints[i] - d);
            if (d == 0.0) continue;
            f += (float)(d2 / d);
        }
        return f / (float)this.yDataPoints.length;
    }

    public float chi2Goodness() {
        return (float)(this.chi2 / (double)(this.yDataPoints.length - this.parameters.length));
    }

    protected double[] checkWeights(int n, double[] dArray) {
        boolean bl = false;
        if (dArray == null) {
            bl = true;
            dArray = new double[n];
        } else {
            boolean bl2 = true;
            boolean bl3 = false;
            for (int i = 0; i < dArray.length && !bl3; ++i) {
                if (dArray[i] < 0.0 || Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i])) {
                    bl3 = true;
                }
                bl2 = dArray[i] == 0.0 && bl2;
            }
            boolean bl4 = bl = bl2 || bl3;
        }
        if (!bl) {
            return dArray;
        }
        System.out.println("WARNING: weights were not well defined. All elements set to 1.");
        Arrays.fill(dArray, 1.0);
        return dArray;
    }

    public double[][] getCovarianceMatrixOfStandardErrorsInParameters() throws LMAMatrix.InvertException {
        double[][] dArray = new double[this.parameters.length][this.parameters.length];
        double d = this.lambda;
        this.lambda = 0.0;
        this.updateAlpha();
        try {
            this.alpha.invert();
        }
        catch (LMAMatrix.InvertException invertException) {
            this.lambda = d;
            this.updateAlpha();
            throw new LMAMatrix.InvertException("Inverting alpha failed with lambda = 0\n" + invertException.getMessage());
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray[i][j] = this.alpha.getElement(i, j);
            }
        }
        this.alpha.invert();
        this.lambda = d;
        this.updateAlpha();
        return dArray;
    }

    public double[] getStandardErrorsOfParameters() throws LMAMatrix.InvertException {
        double[][] dArray = this.getCovarianceMatrixOfStandardErrorsInParameters();
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = new double[this.parameters.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = Math.sqrt(dArray[i][i]);
        }
        return dArray2;
    }

    public double[] generateData() {
        return this.function.generateData(this);
    }
}

