/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.Lens;
import components.Material;
import java.util.ArrayList;
import java.util.logging.Logger;
import utils.ABCDmatrix;
import utils.Formatter;
import utils.JamMtException;
import utils.Observer;

public class Substrate
extends Lens {
    private double n = 1.0;
    private double R1x = Double.NEGATIVE_INFINITY;
    private double R2x = Double.POSITIVE_INFINITY;
    private double R1y = Double.NEGATIVE_INFINITY;
    private double R2y = Double.POSITIVE_INFINITY;
    private Material m = null;
    private double theta = 0.0;
    private int mirror = 0;
    private String coating = "none";

    public Substrate() {
        try {
            this.setIndexOfRefraction(1.0);
            this.setThickness(0.0);
            this.setLeftRoc(Double.NEGATIVE_INFINITY, "x");
            this.setLeftRoc(Double.NEGATIVE_INFINITY, "y");
            this.setRightRoc(Double.POSITIVE_INFINITY, "x");
            this.setRightRoc(Double.POSITIVE_INFINITY, "y");
            this.setName("Substrate");
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }

    public Substrate(double z, double n, double d, double R1, double R2, double a) throws JamMtException {
        this(z, n, d, R1, R2, R1, R2, a);
    }

    public Substrate(double z, double n, double d, double R1x, double R2x, double R1y, double R2y, double a) throws JamMtException {
        super(0.0, 0.1, 0.025);
        this.setPosition(z);
        this.setAperture(a);
        this.setIndexOfRefraction(n);
        this.setThickness(d);
        this.setLeftRoc(R1x, "x");
        this.setLeftRoc(R1y, "y");
        this.setRightRoc(R2x, "x");
        this.setRightRoc(R2y, "y");
        this.setName("Substrate");
    }

    @Override
    public boolean isSymmetric() {
        return this.R1x == this.R1y && this.R2x == this.R2y;
    }

    public void setCoating(String side) throws JamMtException {
        if (!(side.equals("none") || side.equals("left") || side.equals("right"))) {
            throw new JamMtException("Coating can't be on side '" + side + "'!");
        }
        this.coating = side;
    }

    public String getCoating() {
        return this.coating;
    }

    public void setMirror(int mirror) throws JamMtException {
        if (mirror < 0 || mirror > 3) {
            throw new JamMtException("Variable 'mirror' out of range (was " + mirror + ").");
        }
        this.mirror = mirror;
    }

    public int getMirror() {
        return this.mirror;
    }

    public void setMaterial(Material m) {
        this.m = m;
    }

    public Material getMaterial() {
        return this.m;
    }

    public double getIndexOfRefraction() {
        return this.n;
    }

    public void setIndexOfRefraction(double n) throws JamMtException {
        if (n < 1.0) {
            throw new JamMtException("Index of refraction must not be smaller than 1.0!");
        }
        this.n = n;
        this.fireUpdate();
    }

    public double getLeftRoc(String plane) {
        if (plane.equals("x")) {
            return this.R1x;
        }
        return this.R1y;
    }

    public double getRightRoc(String plane) {
        if (plane.equals("x")) {
            return this.R2x;
        }
        return this.R2y;
    }

    public void setLeftRoc(double R) {
        try {
            this.setLeftRoc(R, "x");
            this.setLeftRoc(R, "y");
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    public void setLeftRoc(double R, String plane) throws JamMtException {
        if (R == 0.0) {
            throw new JamMtException("The radius of curvature must not be zero.");
        }
        if (plane.equals("x")) {
            this.R1x = R;
        } else {
            this.R1y = R;
        }
    }

    public void setRightRoc(double R) {
        try {
            this.setRightRoc(R, "x");
            this.setRightRoc(R, "y");
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    public void setRightRoc(double R, String plane) throws JamMtException {
        if (R == 0.0) {
            throw new JamMtException("The radius of curvature must not be zero.");
        }
        if (plane.equals("x")) {
            this.R2x = R;
        } else {
            this.R2y = R;
        }
    }

    public double getAngleInDegrees() {
        return this.theta / Math.PI * 180.0;
    }

    public void setAngleInDegrees(double theta) {
        this.theta = theta / 180.0 * Math.PI;
        this.fireUpdate();
    }

    public double getAngleInRadians() {
        return this.theta;
    }

    public void setAngleInRadians(double theta) {
        this.theta = theta;
        this.fireUpdate();
    }

    @Override
    public double getFocalLength(String plane) {
        double R2;
        double R1;
        double d = this.getThickness();
        if (plane.equals("x")) {
            R1 = this.R1x;
            R2 = this.R2x;
        } else {
            R1 = this.R1y;
            R2 = this.R2y;
        }
        return 1.0 / ((this.n - 1.0) * (1.0 / R2 - 1.0 / R1 + (this.n - 1.0) * d / this.n / R1 / R2));
    }

    public void rotateByDegrees(double deg) {
        this.setAngleInDegrees(deg + this.getAngleInDegrees());
    }

    @Override
    public double getThickness() {
        double theta2 = Math.asin(Math.sin(this.theta));
        return this.d / Math.cos(theta2);
    }

    public void flip() {
        ArrayList<String> planes = new ArrayList<String>();
        planes.add("x");
        planes.add("y");
        try {
            for (String plane : planes) {
                double R = this.getLeftRoc(plane);
                this.setLeftRoc(-this.getRightRoc(plane), plane);
                this.setRightRoc(-R, plane);
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        this.fireUpdate();
    }

    public ABCDmatrix getABCD(String part, String plane) throws JamMtException {
        double R2;
        double R1;
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' not supported!");
        }
        if (!(part.equals("left") || part.equals("right") || part.equals("prop"))) {
            throw new JamMtException("'" + part + "' is not part of a substrate!");
        }
        ABCDmatrix m1 = new ABCDmatrix();
        ABCDmatrix m2 = new ABCDmatrix();
        double th1 = this.theta;
        double th2 = Math.asin(Math.sin(th1) / this.n);
        if (plane.equals("x")) {
            R1 = this.R1x;
            R2 = this.R2x;
        } else {
            R1 = this.R1y;
            R2 = this.R2y;
        }
        m1.setElement("C", (Math.cos(th2) * this.n - Math.cos(th1)) / R1);
        m2.setElement("C", -(Math.cos(th2) * this.n - Math.cos(th1)) / R2);
        if (plane.equals("y")) {
            m1 = new ABCDmatrix(Math.cos(th2) / Math.cos(th1), 0.0, m1.getElement("C") / Math.cos(th1) / Math.cos(th2), Math.cos(th1) / Math.cos(th2));
            m2 = new ABCDmatrix(Math.cos(th1) / Math.cos(th2), 0.0, m2.getElement("C") / Math.cos(th1) / Math.cos(th2), Math.cos(th2) / Math.cos(th1));
        }
        if (part.equals("left")) {
            return m1;
        }
        if (part.equals("right")) {
            return m2;
        }
        return new ABCDmatrix(1.0, this.getThickness() / this.n, 0.0, 1.0);
    }

    @Override
    public ABCDmatrix getABCD(String plane) throws JamMtException {
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' not supported!");
        }
        ABCDmatrix ret = new ABCDmatrix();
        ret.timesLeft(this.getABCD("left", plane));
        ret.timesLeft(this.getABCD("prop", "x"));
        ret.timesLeft(this.getABCD("right", plane));
        return ret;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getInfo() {
        String s = super.getInfo();
        s = s + "\n\u03c6 = " + Formatter.defaultFormat(this.getAngleInDegrees()) + " [deg]";
        return s;
    }

    @Override
    public Object clone() {
        Substrate cpy = null;
        try {
            cpy = new Substrate(this.z, this.n, this.d, this.R1x, this.R2x, this.R1y, this.R2y, this.a);
            cpy.name = this.name;
            cpy.isCurrent = this.isCurrent;
            cpy.gid = this.gid;
            for (Observer o : this.obs) {
                cpy.attach(o);
            }
            cpy.m = this.m;
            cpy.theta = this.theta;
            cpy.mirror = this.mirror;
            cpy.coating = this.coating;
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        return cpy;
    }
}

