/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.util.logging.Logger;
import utils.JamMtException;
import utils.QParameter;

public class PartialBeam
implements Cloneable {
    private double w0x = 0.0;
    private double z0x = 0.0;
    private double w0y = 0.0;
    private double z0y = 0.0;
    private double lambda = 0.0;

    public PartialBeam(double w0, double z0, double lambda) {
        this.w0x = w0;
        this.z0x = z0;
        this.w0y = w0;
        this.z0y = z0;
        this.lambda = lambda;
    }

    public PartialBeam(double w0x, double z0x, double w0y, double z0y, double lambda) throws JamMtException {
        this.setWaistSize(w0x, w0y);
        this.setWaistPosition(z0x, z0y);
        this.setWaveLength(lambda);
    }

    public double getWaveLength() {
        return this.lambda;
    }

    public void setWaveLength(double lambda) throws JamMtException {
        if (lambda <= 0.0) {
            throw new JamMtException("The wavelength has to be greater than zero (was " + lambda + ").");
        }
        this.lambda = lambda;
    }

    public double getWaistSize(String plane) {
        if (plane.equals("x")) {
            return this.w0x;
        }
        return this.w0y;
    }

    public void setWaistSize(double w0) throws JamMtException {
        this.setWaistSize(w0, w0);
    }

    public void setWaistSize(double w0x, double w0y) throws JamMtException {
        if (w0x <= 0.0) {
            throw new JamMtException("Waistsize has to be greater than zero (was w0x = " + w0x + ").");
        }
        if (w0y <= 0.0) {
            throw new JamMtException("Waistsize has to be greater than zero (was w0y = " + w0y + ").");
        }
        this.w0x = w0x;
        this.w0y = w0y;
    }

    public double getWaistPosition(String plane) {
        if (plane.equals("x")) {
            return this.z0x;
        }
        return this.z0y;
    }

    public void setWaistPosition(double z0) {
        this.setWaistPosition(z0, z0);
    }

    public void setWaistPosition(double z0x, double z0y) {
        this.z0x = z0x;
        this.z0y = z0y;
    }

    public double getRayleighRange(String plane) {
        if (plane.equals("x")) {
            return Math.PI * this.w0x * this.w0x / this.lambda;
        }
        return Math.PI * this.w0y * this.w0y / this.lambda;
    }

    public double getSizeAt(double z, String plane) {
        double zr = this.getRayleighRange(plane);
        if (plane.equals("x")) {
            return this.w0x * Math.sqrt(1.0 + Math.pow((z - this.z0x) / zr, 2.0));
        }
        return this.w0y * Math.sqrt(1.0 + Math.pow((z - this.z0y) / zr, 2.0));
    }

    public double getRadiusAt(double z, String plane) {
        double zr = this.getRayleighRange(plane);
        if (plane.equals("x")) {
            if (z == this.z0x) {
                return Double.POSITIVE_INFINITY;
            }
            return (z - this.z0x) * (1.0 + Math.pow(zr / (z - this.z0x), 2.0));
        }
        if (z == this.z0y) {
            return Double.POSITIVE_INFINITY;
        }
        return (z - this.z0y) * (1.0 + Math.pow(zr / (z - this.z0y), 2.0));
    }

    public double getGouyPhaseAt(double z, String plane) {
        double zr = this.getRayleighRange(plane);
        if (plane.equals("x")) {
            return -Math.atan((z - this.z0x) / zr);
        }
        return -Math.atan((z - this.z0y) / zr);
    }

    public QParameter getQParameterAt(double z) {
        QParameter q = null;
        try {
            q = new QParameter(z, z - this.z0x, this.getRayleighRange("x"), z - this.z0y, this.getRayleighRange("y"));
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        return q;
    }

    public double calculateOverlap(PartialBeam b, String plane) {
        double k_1 = Math.PI * 2 / this.getWaveLength();
        double k_2 = Math.PI * 2 / b.getWaveLength();
        double z = 0.0;
        double zr_1 = this.getRayleighRange(plane);
        double zr_2 = b.getRayleighRange(plane);
        double w_1 = this.getSizeAt(z, plane);
        double w_2 = b.getSizeAt(z, plane);
        double R_1 = this.getRadiusAt(z, plane);
        double R_2 = b.getRadiusAt(z, plane);
        double radiant = 1.0 + Math.pow(0.5 * (k_2 / R_2 - k_1 / R_1) / (1.0 / w_1 / w_1 + 1.0 / w_2 / w_2), 2.0);
        return 2.0 / (w_1 * w_2 * (1.0 / w_1 / w_1 + 1.0 / w_2 / w_2)) / Math.sqrt(radiant);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

