/*
 * Decompiled with CFR 0.152.
 */
package components;

import utils.JamMtException;

public class Material {
    private String name = "";
    private double B1 = 0.0;
    private double B2 = 0.0;
    private double B3 = 0.0;
    private double C1 = 0.0;
    private double C2 = 0.0;
    private double C3 = 0.0;

    public Material(String name, double[] B, double[] C) {
        this.setName(name);
        this.setCoefficients(B, C);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double[] getCoefficients() {
        double[] coeffs = new double[]{this.B1, this.B2, this.B3, this.C1, this.C2, this.C3};
        return coeffs;
    }

    public void setCoefficients(double[] B, double[] C) {
        this.B1 = B[0];
        this.B2 = B[1];
        this.B3 = B[2];
        this.C1 = C[0];
        this.C2 = C[1];
        this.C3 = C[2];
    }

    public double getIndexOfRefraction(double lambda) throws JamMtException {
        double ls = lambda * lambda;
        double idx = Math.sqrt(1.0 + this.B1 * ls / (ls - this.C1) + this.B2 * ls / (ls - this.C2) + this.B3 * ls / (ls - this.C3));
        if (idx < 1.0) {
            throw new JamMtException("Index of refraction must be >= 1.0 (was " + idx + "). Please check the Sellmeier coefficients.");
        }
        return idx;
    }

    public String toString() {
        return this.getName();
    }
}

