/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.Component;
import java.util.logging.Logger;
import utils.ABCDmatrix;
import utils.Formatter;
import utils.JamMtException;
import utils.Observer;

public class Lens
extends Component {
    protected double a = 0.025;
    protected boolean isCavityComponent = false;
    private double fx = 0.01;
    private double fy = 0.01;

    public Lens() {
        try {
            this.setPosition(0.0);
            this.setName("Lens");
            this.setFocalLength("x", 0.1);
            this.setFocalLength("y", 0.1);
            this.setAperture(0.025);
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
    }

    public Lens(double z, double f, double a) throws JamMtException {
        this(z, f, f, a);
    }

    public Lens(double z, double fx, double fy, double a) throws JamMtException {
        this.setPosition(z);
        this.setName("Lens");
        this.setFocalLength("x", fx);
        this.setFocalLength("y", fy);
        this.setAperture(a);
    }

    public boolean isCavityComponent() {
        return this.isCavityComponent;
    }

    public void setCavityComponent(boolean comp) {
        this.isCavityComponent = comp;
    }

    public boolean isSymmetric() {
        return this.fx == this.fy;
    }

    public void setFocalLength(double f) {
        try {
            this.setFocalLength("x", f);
            this.setFocalLength("y", f);
        }
        catch (JamMtException jamMtException) {
            // empty catch block
        }
    }

    public void setFocalLength(String plane, double f) throws JamMtException {
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' is not supported");
        }
        if (f == 0.0) {
            throw new JamMtException("Focal length must not be zero!");
        }
        if (plane.equals("x")) {
            this.fx = f;
        } else {
            this.fy = f;
        }
        this.fireUpdate();
    }

    public double getFocalLength(String plane) throws JamMtException {
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' is not supported");
        }
        if (plane.equals("x")) {
            return this.fx;
        }
        return this.fy;
    }

    public void setAperture(double a) throws JamMtException {
        if (a <= 0.0) {
            throw new JamMtException("Aperture has to be greater than zero (was " + a + ").");
        }
        this.a = a;
        this.fireUpdate();
    }

    public double getAperture() {
        return this.a;
    }

    public ABCDmatrix getABCD(String plane) throws JamMtException {
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' is not supported");
        }
        if (plane.equals("x")) {
            return new ABCDmatrix(1.0, 0.0, -1.0 / this.fx, 1.0);
        }
        return new ABCDmatrix(1.0, 0.0, -1.0 / this.fy, 1.0);
    }

    public boolean comparableTo(Object obj) {
        try {
            if (obj instanceof Lens) {
                Lens l = (Lens)obj;
                return this.getFocalLength("x") == l.getFocalLength("x") && this.getPosition() == l.getPosition();
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getInfo() {
        String s = super.getInfo();
        try {
            s = s + "\nf = " + Formatter.autoFormat(this.getFocalLength("x"));
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        return s;
    }

    @Override
    public Object clone() {
        Lens cpy = null;
        try {
            cpy = new Lens(this.z, this.fx, this.fy, this.a);
            cpy.name = this.name;
            cpy.z = this.z;
            cpy.d = this.d;
            cpy.isCurrent = this.isCurrent;
            cpy.gid = this.gid;
            cpy.isCavityComponent = this.isCavityComponent;
            for (Observer o : this.obs) {
                cpy.attach(o);
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        return cpy;
    }
}

