/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.Component;
import components.Lens;
import components.Material;
import components.Substrate;
import io.XmlDoc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import utils.ComponentSet;
import utils.JamMtException;
import utils.Settings;

public class Database {
    private String name = "JamMt database";
    private boolean enabled = true;
    private ArrayList<Material> materials = new ArrayList();
    private ArrayList<Lens> substrates = new ArrayList();

    public Database(String name) {
        this.name = name;
    }

    public Database(File file) {
        int idx = file.getName().lastIndexOf(".");
        this.name = file.getName().substring(0, idx);
        try {
            XmlDoc doc = new XmlDoc(file.getAbsolutePath(), false);
            this.materials = doc.loadMaterials();
            ArrayList<Component> tmp = doc.loadLensSet("LSavail", null);
            for (Component c : tmp) {
                if (!(c instanceof Substrate)) continue;
                this.addSubstrate((Substrate)c);
            }
            String path = Settings.DB_FOLDER + Settings.FS;
            if (new File(path + this.name + ".disabled").exists()) {
                this.enabled = false;
            }
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").warning("Failed to import database from file '" + file.getAbsolutePath() + "'");
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addMaterial(Material m) {
        this.materials.add(m);
    }

    public void addSubstrate(Substrate s) {
        this.substrates.add(s);
    }

    public void writeToFile() {
        String path = Settings.DB_FOLDER + Settings.FS;
        String fname = path + this.name + ".jamDB";
        try {
            File f = new File(path + this.name + ".disabled");
            if (this.enabled) {
                f.delete();
            } else {
                f.createNewFile();
            }
        }
        catch (IOException e) {
            Logger.getLogger("JamMt").severe(e.toString());
        }
        this.writeToFile(fname);
    }

    public void writeToFile(String fname) {
        try {
            XmlDoc doc = new XmlDoc(fname, true);
            doc.writeMaterials(this.materials);
            doc.writeLensSet(this.substrates, "LSavail");
            doc.close();
        }
        catch (JamMtException e) {
            Logger.getLogger("JamMt").warning("Failed to export database to file '" + fname + "'");
        }
    }

    public ComponentSet getComponents() {
        ComponentSet set = new ComponentSet();
        for (Lens l : this.substrates) {
            set.addComponent(l);
        }
        return set;
    }

    public ArrayList<Lens> getSubstrates() {
        return this.substrates;
    }

    public ArrayList<Material> getMaterials() {
        return this.materials;
    }

    public String contentsToString() {
        String content = "Database overview:\n";
        content = content + "\n  Found " + this.materials.size() + " material(s):\n";
        for (Material m : this.materials) {
            content = content + "    " + m.getName() + "\n";
        }
        content = content + "\n  Found " + this.substrates.size() + " substrate(s):\n";
        for (Lens sub : this.substrates) {
            content = content + "    " + sub.getName() + "\n";
        }
        return content;
    }

    public String toString() {
        String s = this.name;
        s = this.enabled ? s + ", enabled" : s + ", disabled";
        return s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

