/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import utils.Formatter;
import utils.JamMtException;
import utils.Observer;

public class Component
implements Comparable<Component>,
Cloneable {
    protected List<Observer> obs = new ArrayList<Observer>();
    protected String name = "Component";
    protected double z = 0.0;
    protected double d = 0.0;
    protected boolean isCurrent = false;
    protected int gid = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireUpdate();
    }

    public double getPosition() {
        return this.z;
    }

    public void setPosition(double z) {
        this.z = z;
        this.fireUpdate();
    }

    public boolean isCurrent() {
        return this.isCurrent;
    }

    public void setCurrent(boolean cur) {
        this.isCurrent = cur;
        this.fireUpdate();
    }

    public int getGroupID() {
        return this.gid;
    }

    public void setGroupID(int gid) throws JamMtException {
        if (gid < 0 || gid > 19) {
            throw new JamMtException("The group ID has to be an integer between 0 and 19 (was " + gid + ")");
        }
        this.gid = gid;
        this.fireUpdate();
    }

    public double getThickness() {
        return this.d;
    }

    public void setThickness(double d) throws JamMtException {
        if (d < 0.0) {
            throw new JamMtException("The thickness has to be greater than zero (was " + d + ")");
        }
        this.d = d;
        this.fireUpdate();
    }

    public double distanceTo(Component c) {
        return c.getPosition() - this.getPosition();
    }

    public Object clone() {
        Component cpy = new Component();
        cpy.name = this.name;
        cpy.z = this.z;
        cpy.d = this.d;
        cpy.isCurrent = this.isCurrent;
        cpy.gid = this.gid;
        for (Observer o : this.obs) {
            cpy.attach(o);
        }
        return cpy;
    }

    @Override
    public int compareTo(Component comp) {
        if (this.z < comp.z) {
            return -1;
        }
        return 1;
    }

    public void attach(Observer o) {
        if (!this.obs.contains(o)) {
            this.obs.add(o);
        }
    }

    public void detach(Observer o) {
        if (this.obs.contains(o)) {
            this.obs.remove(o);
        }
    }

    public void detachAll() {
        this.obs.clear();
    }

    public void fireUpdate() {
        Iterator<Observer> it = this.obs.iterator();
        while (it.hasNext()) {
            it.next().update(this);
        }
    }

    protected void finalize() {
        for (Observer o : this.obs) {
            this.detach(o);
        }
    }

    public String getInfo() {
        String s = this.name;
        s = s + "\nz = " + Formatter.defaultFormat(this.getPosition()) + " m";
        return s;
    }
}

