/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.Lens;
import components.PartialBeam;
import components.Substrate;
import java.util.ListIterator;
import java.util.logging.Logger;
import utils.ABCDmatrix;
import utils.ComponentSet;
import utils.JamMtException;
import utils.QParameter;

public class Cavity {
    private ComponentSet lenses;
    private String name;
    private Substrate m1;
    private Substrate m2;
    private boolean group = false;
    private PartialBeam innerMode;
    private PartialBeam outerMode;
    private double g_x = 0.0;
    private double g_y = 0.0;

    public Cavity(String name, Substrate m1, Substrate m2, boolean group, String ref1, String ref2) {
        this.setName(name);
        this.m1 = m1;
        this.m2 = m2;
        try {
            this.m1.setCoating(ref1);
            this.m2.setCoating(ref2);
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        this.lenses = new ComponentSet();
        this.lenses.addComponent(m1);
        this.lenses.addComponent(m2);
        this.group = group;
    }

    public Cavity(String name, ComponentSet lenses, boolean group, String ref1, String ref2) throws JamMtException {
        if (lenses.getLenses().size() == 0) {
            throw new JamMtException("Cavity has to consist of at least one substrate!");
        }
        if (!(lenses.getFirstLens() instanceof Substrate) && !(lenses.getLastLens() instanceof Substrate)) {
            throw new JamMtException("Cavity end mirrors have to be substrates!");
        }
        this.lenses = lenses;
        this.m1 = (Substrate)lenses.getFirstLens();
        this.m2 = (Substrate)lenses.getLastLens();
        this.setName(name);
        try {
            this.m1.setCoating(ref1);
            this.m2.setCoating(ref2);
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        this.group = group;
    }

    public boolean isStable() {
        try {
            this.g_x = this.getStabilityParameter("x");
            this.g_y = this.getStabilityParameter("y");
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        return !(Math.abs(this.g_x) > 1.0) && !(Math.abs(this.g_y) > 1.0);
    }

    public void setEndMirror(String side, Substrate s) throws JamMtException {
        if (!side.equals("left") && !side.equals("right")) {
            throw new JamMtException("Side '" + side + "' not recognized!");
        }
        if (side.equals("left")) {
            this.m1 = s;
        } else {
            this.m2 = s;
        }
    }

    public Substrate getEndMirror(String side) throws JamMtException {
        if (!side.equals("left") && !side.equals("right")) {
            throw new JamMtException("Side '" + side + "' not recognized!");
        }
        if (side.equals("left")) {
            return this.m1;
        }
        return this.m2;
    }

    public double getStabilityParameter(String plane) throws JamMtException {
        if (!plane.equals("x") && !plane.equals("y")) {
            throw new JamMtException("Plane '" + plane + "' not supported!");
        }
        ABCDmatrix Mx = this.getABCD("x");
        ABCDmatrix My = this.getABCD("y");
        this.g_x = Mx.trace() / 2.0;
        this.g_y = My.trace() / 2.0;
        if (plane.equals("x")) {
            return this.g_x;
        }
        return this.g_y;
    }

    public boolean isGrouped() {
        return this.group;
    }

    public void setGrouped(boolean group) {
        this.group = group;
    }

    public ComponentSet getComponents() {
        return this.lenses;
    }

    public void setComponents(ComponentSet ls) throws JamMtException {
        if (ls.getLenses().size() == 0) {
            throw new JamMtException("A cavity has to consist of at least one substrate!");
        }
        if (!(ls.getLastLens() instanceof Substrate) || !(ls.getFirstLens() instanceof Substrate)) {
            throw new JamMtException("The endmirrors have to be substrates!");
        }
        Substrate s1 = (Substrate)ls.getFirstLens();
        Substrate s2 = (Substrate)ls.getLastLens();
        if (!s1.getCoating().equals("left") && !s1.getCoating().equals("right")) {
            throw new JamMtException("The left endmirror has no coating!");
        }
        if (!s2.getCoating().equals("left") && !s2.getCoating().equals("right")) {
            throw new JamMtException("The right endmirror has no coating!");
        }
        this.lenses = new ComponentSet();
        for (Lens l : ls.getLenses()) {
            this.lenses.addComponent(l);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PartialBeam getInnerEigenmode(double lambda) {
        this.getEigenmode(lambda);
        return this.innerMode;
    }

    public PartialBeam getEigenmode(double lambda) {
        ABCDmatrix Mx = new ABCDmatrix();
        ABCDmatrix My = new ABCDmatrix();
        QParameter q = null;
        double reX = 0.0;
        double imX = 0.0;
        double reY = 0.0;
        double imY = 0.0;
        double z = this.m1.getCoating().equals("left") || this.m1 == this.m2 ? this.m1.getPosition() - this.m1.getThickness() / 2.0 : this.m1.getPosition() + this.m1.getThickness() / 2.0;
        Mx = this.getABCD("x");
        My = this.getABCD("y");
        if (!this.isStable()) {
            return null;
        }
        try {
            reX = (Mx.getElement("A") - Mx.getElement("D")) / 2.0 / Mx.getElement("C");
            imX = Math.sqrt(1.0 - this.g_x * this.g_x) / Math.abs(Mx.getElement("C"));
            reY = (My.getElement("A") - My.getElement("D")) / 2.0 / My.getElement("C");
            imY = Math.sqrt(1.0 - this.g_y * this.g_y) / Math.abs(My.getElement("C"));
            q = new QParameter(z, reX, imX, reY, imY);
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        double n = this.m1.getCoating().equals("right") && this.m1 != this.m2 ? 1.0 : this.m1.getIndexOfRefraction();
        this.innerMode = q.toBeam(n, lambda);
        try {
            if (this.m1.getCoating().equals("right") && this.m1 != this.m2) {
                Mx = this.m1.getABCD("x").invert();
                My = this.m1.getABCD("y").invert();
                z -= this.m1.getThickness();
            } else {
                Mx = this.m1.getABCD("left", "x").invert();
                My = this.m1.getABCD("left", "y").invert();
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        q.propagate(Mx, My, z);
        this.outerMode = q.toBeam(1.0, lambda);
        return this.outerMode;
    }

    public ABCDmatrix getABCD(String plane) {
        ABCDmatrix coeff = new ABCDmatrix();
        double d = 0.0;
        Lens l1 = this.m1;
        Lens l2 = this.m2;
        if (this.m1 == this.m2) {
            double n = this.m1.getIndexOfRefraction();
            try {
                coeff.timesLeft(this.m1.getABCD("prop", plane));
                coeff.timesLeft(new ABCDmatrix(1.0, 0.0, -2.0 * n / this.m1.getRightRoc(plane), 1.0));
                coeff.timesLeft(this.m1.getABCD("prop", plane));
                coeff.timesLeft(new ABCDmatrix(1.0, 0.0, 2.0 * n / this.m1.getLeftRoc(plane), 1.0));
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
            return coeff;
        }
        ListIterator<Lens> it = this.lenses.getLenses().listIterator(0);
        if (this.m1.getCoating().equals("left")) {
            try {
                coeff.timesLeft(this.m1.getABCD("prop", plane));
                coeff.timesLeft(this.m1.getABCD("right", plane));
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
        }
        l1 = it.next();
        while (it.hasNext()) {
            l2 = it.hasNext() ? it.next() : null;
            d = this.lenses.getSpaceBetween(l1, l2);
            try {
                coeff.timesLeft(new ABCDmatrix(1.0, d, 0.0, 1.0));
                if (l2 != null && this.lenses.getLastLens() != l2) {
                    coeff.timesLeft(l2.getABCD(plane));
                }
            }
            catch (JamMtException je) {
                Logger.getLogger("JamMt").severe(je.toString());
            }
            l1 = l2;
        }
        try {
            if (this.m2.getCoating().equals("left")) {
                coeff.timesLeft(new ABCDmatrix(1.0, 0.0, -2.0 / this.m2.getLeftRoc(plane), 1.0));
            } else {
                double n = this.m2.getIndexOfRefraction();
                coeff.timesLeft(this.m2.getABCD("left", plane));
                coeff.timesLeft(this.m2.getABCD("prop", plane));
                coeff.timesLeft(new ABCDmatrix(1.0, 0.0, -2.0 * n / this.m2.getRightRoc(plane), 1.0));
                coeff.timesLeft(this.m2.getABCD("prop", plane));
                coeff.timesLeft(this.m2.getABCD("left", plane));
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        it = this.lenses.getLenses().listIterator(this.lenses.getLenses().size());
        l1 = it.previous();
        try {
            while (it.hasPrevious()) {
                l2 = it.hasPrevious() ? it.previous() : null;
                d = this.lenses.getSpaceBetween(l1, l2);
                coeff.timesLeft(new ABCDmatrix(1.0, d, 0.0, 1.0));
                if (l2 != null && this.lenses.getFirstLens() != l2) {
                    if (l2 instanceof Substrate) {
                        coeff.timesLeft(((Substrate)l2).getABCD("right", plane));
                        coeff.timesLeft(((Substrate)l2).getABCD("prop", plane));
                        coeff.timesLeft(((Substrate)l2).getABCD("left", plane));
                    } else {
                        coeff.timesLeft(l2.getABCD(plane));
                    }
                }
                l1 = l2;
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        try {
            if (this.m1.getCoating().equals("right")) {
                coeff.timesLeft(new ABCDmatrix(1.0, 0.0, 2.0 / this.m1.getRightRoc(plane), 1.0));
            } else {
                double n = this.m1.getIndexOfRefraction();
                coeff.timesLeft(this.m1.getABCD("right", plane));
                coeff.timesLeft(this.m1.getABCD("prop", plane));
                coeff.timesLeft(new ABCDmatrix(1.0, 0.0, 2.0 * n / this.m1.getLeftRoc(plane), 1.0));
            }
        }
        catch (JamMtException je) {
            Logger.getLogger("JamMt").severe(je.toString());
        }
        return coeff;
    }

    public boolean contains(Lens l) {
        double pos = l.getPosition();
        return pos >= this.m1.getPosition() && pos <= this.m2.getPosition();
    }
}

