/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.Component;
import utils.Beam;
import utils.Formatter;
import utils.JamMtException;

public class BeamAnalyzer
extends Component {
    private Beam b;

    public BeamAnalyzer(String name, double z, int gid) throws JamMtException {
        this(name, z, gid, null);
    }

    public BeamAnalyzer(String name, double z, int gid, Beam b) throws JamMtException {
        this.setName(name);
        this.setPosition(z);
        this.setGroupID(gid);
        this.b = b;
    }

    public void setBeam(Beam b) {
        this.b = b;
    }

    @Override
    public String getInfo() {
        String s = super.getInfo();
        if (this.b != null) {
            s = s + "\nw = " + Formatter.defaultFormat(this.b.getWaistSizeAt(this.z, "x") * 1000000.0) + " \u03bcm";
            s = s + "\n\u03c6 = " + Formatter.defaultFormat(this.b.getGouyPhaseAt(this.z, "x") * 180.0 / Math.PI) + " [deg]";
        }
        return s;
    }
}

