/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLArray;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLStructure
extends MLArray {
    private Set<String> keys;
    private List<Map<String, MLArray>> mlStructArray;
    private int currentIndex = 0;

    public MLStructure(String string, int[] nArray) {
        this(string, nArray, 2, 0);
    }

    public MLStructure(String string, int[] nArray, int n, int n2) {
        super(string, nArray, n, n2);
        this.mlStructArray = new ArrayList<Map<String, MLArray>>(nArray[0] * nArray[1]);
        this.keys = new LinkedHashSet<String>();
    }

    public void setField(String string, MLArray mLArray) {
        this.setField(string, mLArray, this.currentIndex);
    }

    public void setField(String string, MLArray mLArray, int n, int n2) {
        this.setField(string, mLArray, this.getIndex(n, n2));
    }

    public void setField(String string, MLArray mLArray, int n) {
        this.keys.add(string);
        this.currentIndex = n;
        if (this.mlStructArray.isEmpty() || this.mlStructArray.size() <= n) {
            this.mlStructArray.add(n, new LinkedHashMap());
        }
        this.mlStructArray.get(n).put(string, mLArray);
    }

    public int getMaxFieldLenth() {
        int n = 0;
        for (String string : this.keys) {
            n = string.length() > n ? string.length() : n;
        }
        return n + 1;
    }

    public byte[] getKeySetToByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        char[] cArray = new char[this.getMaxFieldLenth()];
        try {
            for (String string : this.keys) {
                Arrays.fill(cArray, '\u0000');
                System.arraycopy(string.toCharArray(), 0, cArray, 0, string.length());
                dataOutputStream.writeBytes(new String(cArray));
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not write Structure key set to byte array: " + iOException);
            return new byte[0];
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Collection<MLArray> getAllFields() {
        ArrayList<MLArray> arrayList = new ArrayList<MLArray>();
        for (Map<String, MLArray> map : this.mlStructArray) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public MLArray getField(String string) {
        return this.getField(string, this.currentIndex);
    }

    public MLArray getField(String string, int n, int n2) {
        return this.getField(string, this.getIndex(n, n2));
    }

    public MLArray getField(String string, int n) {
        return this.mlStructArray.get(n).get(string);
    }

    @Override
    public String contentToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name + " = \n");
        if (this.getM() * this.getN() == 1) {
            for (String string : this.keys) {
                stringBuffer.append("\t" + string + " : " + this.getField(string) + "\n");
            }
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(this.getM() + "x" + this.getN());
            stringBuffer.append(" struct array with fields: \n");
            for (String string : this.keys) {
                stringBuffer.append("\t" + string + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

