/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLDouble
extends MLNumericArray<Double> {
    public MLDouble(String string, int[] nArray, int n, int n2) {
        super(string, nArray, n, n2);
    }

    public MLDouble(String string, int[] nArray) {
        super(string, nArray, 6, 0);
    }

    public MLDouble(String string, Double[] doubleArray, int n) {
        super(string, 6, (Number[])doubleArray, n);
    }

    public MLDouble(String string, double[][] dArray) {
        this(string, MLDouble.double2DToDouble(dArray), dArray.length);
    }

    public MLDouble(String string, double[] dArray, int n) {
        this(string, MLDouble.castToDouble(dArray), n);
    }

    public Double[] createArray(int n, int n2) {
        return new Double[n * n2];
    }

    public double[][] getArray() {
        double[][] dArrayArray = new double[this.getM()][];
        for (int i = 0; i < this.getM(); ++i) {
            dArrayArray[i] = new double[this.getN()];
            for (int j = 0; j < this.getN(); ++j) {
                dArrayArray[i][j] = (Double)this.getReal(i, j);
            }
        }
        return dArrayArray;
    }

    private static Double[] castToDouble(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    private static Double[] double2DToDouble(double[][] dArray) {
        Double[] doubleArray = new Double[dArray.length * dArray[0].length];
        for (int i = 0; i < dArray[0].length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                doubleArray[j + i * dArray.length] = dArray[j][i];
            }
        }
        return doubleArray;
    }

    @Override
    public int getBytesAllocated() {
        return 8;
    }

    @Override
    public Double buldFromBytes(byte[] byArray) {
        if (byArray.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(byArray).getDouble();
    }

    @Override
    public byte[] getByteArray(Double d) {
        int n = this.getBytesAllocated();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putDouble(d);
        return byteBuffer.array();
    }

    @Override
    public Class<Double> getStorageClazz() {
        return Double.class;
    }
}

