/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

public class MLArray {
    public static final int mxUNKNOWN_CLASS = 0;
    public static final int mxCELL_CLASS = 1;
    public static final int mxSTRUCT_CLASS = 2;
    public static final int mxOBJECT_CLASS = 3;
    public static final int mxCHAR_CLASS = 4;
    public static final int mxSPARSE_CLASS = 5;
    public static final int mxDOUBLE_CLASS = 6;
    public static final int mxSINGLE_CLASS = 7;
    public static final int mxINT8_CLASS = 8;
    public static final int mxUINT8_CLASS = 9;
    public static final int mxINT16_CLASS = 10;
    public static final int mxUINT16_CLASS = 11;
    public static final int mxINT32_CLASS = 12;
    public static final int mxUINT32_CLASS = 13;
    public static final int mxINT64_CLASS = 14;
    public static final int mxUINT64_CLASS = 15;
    public static final int mxFUNCTION_CLASS = 16;
    public static final int mxOPAQUE_CLASS = 17;
    public static final int mtFLAG_COMPLEX = 2048;
    public static final int mtFLAG_GLOBAL = 1024;
    public static final int mtFLAG_LOGICAL = 512;
    public static final int mtFLAG_TYPE = 255;
    protected int[] dims;
    public String name;
    protected int attributes;
    protected int type;

    public MLArray(String string, int[] nArray, int n, int n2) {
        this.dims = new int[nArray.length];
        System.arraycopy(nArray, 0, this.dims, 0, nArray.length);
        this.name = string != null && !string.equals("") ? string : "@";
        this.type = n;
        this.attributes = n2;
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        int n = this.type & 0xFF | this.attributes & 0xFFFFFF00;
        return n;
    }

    public byte[] getNameToByteArray() {
        return this.name.getBytes();
    }

    public int[] getDimensions() {
        int[] nArray = null;
        if (this.dims != null) {
            nArray = new int[this.dims.length];
            System.arraycopy(this.dims, 0, nArray, 0, this.dims.length);
        }
        return nArray;
    }

    public int getM() {
        int n = 0;
        if (this.dims != null) {
            n = this.dims[0];
        }
        return n;
    }

    public int getN() {
        int n = 0;
        if (this.dims != null) {
            if (this.dims.length > 2) {
                n = 1;
                for (int i = 1; i < this.dims.length; ++i) {
                    n *= this.dims[i];
                }
            } else {
                n = this.dims[1];
            }
        }
        return n;
    }

    public int getNDimensions() {
        int n = 0;
        if (this.dims != null) {
            n = this.dims.length;
        }
        return n;
    }

    public int getSize() {
        return this.getM() * this.getN();
    }

    public int getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.getN() == 0;
    }

    public static final String typeToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "cell";
                break;
            }
            case 2: {
                string = "struct";
                break;
            }
            case 4: {
                string = "char";
                break;
            }
            case 5: {
                string = "sparse";
                break;
            }
            case 6: {
                string = "double";
                break;
            }
            case 7: {
                string = "single";
                break;
            }
            case 8: {
                string = "int8";
                break;
            }
            case 9: {
                string = "uint8";
                break;
            }
            case 10: {
                string = "int16";
                break;
            }
            case 11: {
                string = "uint16";
                break;
            }
            case 12: {
                string = "int32";
                break;
            }
            case 13: {
                string = "uint32";
                break;
            }
            case 14: {
                string = "int64";
                break;
            }
            case 15: {
                string = "uint64";
                break;
            }
            case 16: {
                string = "function_handle";
                break;
            }
            case 17: {
                string = "opaque";
                break;
            }
            case 3: {
                string = "object";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public boolean isCell() {
        return this.type == 1;
    }

    public boolean isChar() {
        return this.type == 4;
    }

    public boolean isComplex() {
        return (this.attributes & 0x800) != 0;
    }

    public boolean isSparse() {
        return this.type == 5;
    }

    public boolean isStruct() {
        return this.type == 2;
    }

    public boolean isDouble() {
        return this.type == 6;
    }

    public boolean isSingle() {
        return this.type == 7;
    }

    public boolean isInt8() {
        return this.type == 8;
    }

    public boolean isUint8() {
        return this.type == 9;
    }

    public boolean isInt16() {
        return this.type == 10;
    }

    public boolean isUint16() {
        return this.type == 11;
    }

    public boolean isInt32() {
        return this.type == 12;
    }

    public boolean isUint32() {
        return this.type == 13;
    }

    public boolean isInt64() {
        return this.type == 14;
    }

    public boolean isUint64() {
        return this.type == 15;
    }

    public boolean isObject() {
        return this.type == 3;
    }

    public boolean isOpaque() {
        return this.type == 17;
    }

    public boolean isLogical() {
        return (this.attributes & 0x200) != 0;
    }

    public boolean isFunctionObject() {
        return this.type == 16;
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    protected int getIndex(int n, int n2) {
        return n + n2 * this.getM();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dims != null) {
            stringBuffer.append('[');
            if (this.dims.length > 3) {
                stringBuffer.append(this.dims.length);
                stringBuffer.append('D');
            } else {
                stringBuffer.append(this.dims[0]);
                stringBuffer.append('x');
                stringBuffer.append(this.dims[1]);
                if (this.dims.length == 3) {
                    stringBuffer.append('x');
                    stringBuffer.append(this.dims[2]);
                }
            }
            stringBuffer.append("  ");
            stringBuffer.append(MLArray.typeToString(this.type));
            stringBuffer.append(" array");
            if (this.isSparse()) {
                stringBuffer.append(" (sparse");
                if (this.isComplex()) {
                    stringBuffer.append(" complex");
                }
                stringBuffer.append(")");
            } else if (this.isComplex()) {
                stringBuffer.append(" (complex)");
            }
            stringBuffer.append(']');
        } else {
            stringBuffer.append("[invalid]");
        }
        return stringBuffer.toString();
    }

    public String contentToString() {
        return "content cannot be displayed";
    }

    public void dispose() {
    }
}

